<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="utf-8" />
    <title>StattBuchung-PHP</title>
    	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.6/css/bootstrap.min.css" integrity="sha384-rwoIResjU2yc3z8GV/NPeZWAv56rSmLldC3R/AZzGRnGxQQKnKkoFVhFQhNUwEyJ" crossorigin="anonymous">
	<link rel="stylesheet" href="style/default.css">
	<link rel="stylesheet" href="style/bidat.css">

	<link rel="stylesheet" href="style/font-awesome.min.css">
	
	<link href="https://www.verkehrsakademie-franken.com/index.php/termine?format=feed&amp;type=rss" rel="alternate" type="application/rss+xml" title="RSS 2.0">
	<link href="https://www.verkehrsakademie-franken.com/index.php/termine?format=feed&amp;type=atom" rel="alternate" type="application/atom+xml" title="Atom 1.0">
	<link href="https://www.verkehrsakademie-franken.com/media/com_eventbooking/assets/bootstrap/css/bootstrap.css" rel="stylesheet">
	<link href="https://www.verkehrsakademie-franken.com/media/com_eventbooking/assets/css/font-awesome.min.css" rel="stylesheet">
	<link href="https://www.verkehrsakademie-franken.com/media/com_eventbooking/assets/css/style.css" rel="stylesheet">
	<link href="https://www.verkehrsakademie-franken.com/media/com_eventbooking/assets/css/themes/sky.css" rel="stylesheet">
	<link href="https://www.verkehrsakademie-franken.com/media/com_eventbooking/assets/js/colorbox/colorbox.css" rel="stylesheet">
	<link href="https://www.verkehrsakademie-franken.com/templates/yootheme/css/theme.12.css?v=1541452592" rel="stylesheet" id="theme-style-css">
	<link href="https://www.verkehrsakademie-franken.com/media/widgetkit/wk-styles-e33f5522.css" rel="stylesheet" id="wk-styles-css">
	


</head>
 
<?php
    include('client.php');
	$ini = parse_ini_file('config.ini');
	
	$navigation = file_get_contents('./nav.html', true);
	
    
?>
 
 
<body id='bidat'>
	
	<?php echo $navigation; ?>

<?php

if ($ini['apikey']=='true') {
	echo "<div class='container'><form action='index.php' method='GET'>";
	echo "<input type='text' name='query'/>	<input type='submit' value='Search'/>";
	echo "</form></div>"; 
} 
?>
<div id="tm-main" class="tm-main uk-section uk-section-default" uk-height-viewport="expand: true" style="min-height: 494px;">
<div class="uk-container">

<?php
 
$debug=false;
 
 
define("opcObjectlistProdukt", 256160);
define("opcObjectlistEventNachZeitraum", 255100);
define("opcQueryProdukt",256167);
define("opcLoadProduktContainer",256168);
define("opcFetchTreffpunkt",256141);
define("opcCalendarByChannel",257000);
define("opcFetchTermindetail",257001);
define("opcAddAnmeldung",257002);



define("lorem", "Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.");

function renderProduktliste($resp, $sessionInfo, $query) {
	echo "<div class='container'>";
	echo "<div class='result'><h3><span class='fa fa-search'></span>Die Suche nach <em>".$query."</em> ergab ".$resp["items"][0]["resultSetCount"]." Teffer</h3>";
	$queryresult = $resp["items"];

	foreach ($resp[items][0][items] as $produkt) {
		echo "<div class='produktlistitem'><span class='fa  fa-external-link'></span>";
		echo "<a href='index.php?produkt=".$produkt["oid"]."'>";
		echo $produkt["label"];
		echo "</a>";
		echo "</div>";
	}
	echo "</div>";
	echo "</div>";

}


function renderAnmeldeformular($resp, $sessionInfo) {
	echo "<article>";
	echo "<form id='needs-validation' class='needs-validation' action='index.php?register=872' method='post'>";
	
	echo "<input type='hidden' name='de_stattbuchung_event_Modul' value='".$resp['oid']."' required/>";

	
	echo "<div class='formrow'><label>Anrede</label>";
	echo "<input list='anrede' placeholder='Anrede auswählen' name='anrede' allowautofill='no' required/>";
	echo "<datalist id='anrede'>";
	echo "<option value='Herr'>";
	echo "<option value='Frau'>";
	echo "</datalist>" ;
	echo "</div>";
	

	
	$feldliste = array ("Vorname", "Nachname", "Strasse", "PLZ", "Ort", "Email"); 
	foreach ($feldliste as $feld) {
		echo "<div class='formrow'>";
		echo "<label>".$feld."</label>";
		echo "<input type='text' id='".strtolower($feld)."' name='".strtolower($feld)."' required/>";
		echo "</div>";
	}


	echo "  <div class='formrow'>";
	echo "    <label class='form-check-label' for='datenschutz'>Ich Stimme den Datenschutzbestimmungen zu</label>";
	echo "    <input type='checkbox' class='form-check-input' id='datenschutz' required/>";
	#echo "  </div><div><h3>Wollen Sie uns noch etwas mitteilen?</h3></div>";
  
  
	echo "  <div class='formrow'>";
	echo "    <label for='kommentar'>Bemerkung</label>";
	echo "    <textarea class='form-control bidat_textarea' id='kommentar' name='kommentar' rows='3'></textarea>";
	echo "  </div>";
  



	echo "<div class='formrow'> <button type='submit' class='btn btn-primary'>Anmeldung abschicken</button></div>";
	echo "</form>";
	echo "</article>";
	
	
	
	echo "<script>";
	echo "// Example starter JavaScript for disabling form submissions if there are invalid fields";
	echo "(function() {";
	echo "  'use strict';";
	echo "  window.addEventListener('load', function() {";
	echo "    // Fetch all the forms we want to apply custom Bootstrap validation styles to";
	echo "    var forms = document.getElementsByClassName('needs-validation');";
	echo "    // Loop over them and prevent submission";
	echo "    var validation = Array.prototype.filter.call(forms, function(form) {";
	echo "      form.addEventListener('submit', function(event) {";
	echo "        if (form.checkValidity() === false) {";
	echo "          event.preventDefault();";
	echo "          event.stopPropagation();";
	echo "        }";
	echo "        form.classList.add('was-validated');";
	echo "      }, false);";
	echo "    });";
	echo "  }, false);";
	echo "})();";
	echo "</script>";

	
	
	
}


function renderTerminliste($resp, $sessionInfo, $query) {
	echo "<table class='table table-striped table-bordered table-condensed eb-responsive-table'>";
	echo "<thead><tr><th>Termin</th><th class='date_col'>Datum, Uhrzeit</th><th class='capacity_col'>max.&nbsp;Teilnehmer</th><th class='registered_col'>aktuelle&nbsp;Teilnehmer</th><th class='center available-place-col'>verfügbare Plätze</th><th class='center actions-col'>Anmelden</th></tr></thead>";
	
	echo "<tbody>";
	date_default_timezone_set('Europe/Berlin');

	foreach ($resp[items][0][items] as $termin) {
		$von = new DateTime($termin["von"]);

		echo "<tr>";
		echo "<td class='tdno0' data-content=''>";
			echo"<a href='index.php?modul=".$termin["oid"]."'>".$termin["produkt_titel"]."</a>";
		echo "</td>";
	
		echo "<td class='tdno1' data-content='Datum, Uhrzeit'>";
			//echo $termin["von"];
			echo $von->format('j.m.Y \a\b H:i');
		echo "</td>";

		echo "<td class='tdno2' data-content='max. Teilnehmer'>";
			echo $termin["maxtn"];
		echo "</td>";

		echo "<td class='tdno3' data-content='angemeldet'>";
			echo $termin["tn"];
		echo "</td>";

		echo "<td class='tdno4' data-content='freie Plätze'>";
			echo $termin["maxtn"] - $termin["tn"];
		echo "</td>";


		echo "<td class='tdno4' data-content='Anmeldung'>";
		
		renderAnmeldeButton($termin["maxtn"], $termin["tn"], $termin["oid"]);
		echo "</td>";
		
	
		echo "</tr>";
	}
	echo "</tbody>";
	echo "</table>";

}

function renderAnmeldeButton($maxtn, $tn, $oid) {
		if($maxtn <= $tn) {
			echo "Keine Anmeldung möglich";		
		} else {
			echo "<div class='eb-taskbar'><ul><li>";
			echo "<a class='btn ' href='index.php?form=".$oid."'>Anmeldung</a>";
			echo "</li></ul></div>";
		}
}


function fetchTermindetail($id, $sessionInfo, $apikey) {
    
    $params=array(
	    	"oid" => $id,
    		"de_stattbuchung_event_Modul"=>$id,
    		"de_stattbuchung_Kanal"=>$apikey
    	);
   	$resp=post($sessionInfo, opcFetchTermindetail, $params, "{}", $debug) ;


	return $resp;
}

function sendAnmeldung($id, $sessionInfo, $apikey, $oidang, $postdata) {
    
    $params=array(
	    	"oid" => $postdata['de_stattbuchung_event_Modul'],
	    	"anrede"=>$postdata['anrede'],
	    	"vorname"=>$postdata['vorname'],
	    	"nachname"=>$postdata['nachname'],
	    	"strasse"=>$postdata['strasse'],
	    	"plz"=>$postdata['plz'],
	    	"ort"=>$postdata['ort'],
	    	"email"=>$postdata['email'],
	    	"kommentar"=>$postdata['kommentar'],
    		"de_stattbuchung_event_Modul"=>$postdata['de_stattbuchung_event_Modul'],
    		"de_stattbuchung_Kanal"=>$apikey,
    		"systems_sdw_hr_Angestellter"=>$oidang
    	);
   	$resp=post($sessionInfo, opcAddAnmeldung, $params, "{}", $debug) ;

  # 	echo var_dump($resp);

if($resp['beschreibung'] == 'OK') {
	echo "<h1>Herzlichen Dank für Ihre Anmeldung</h1>";
	echo "<div>Sie sollten in Kürze eine Nachricht über die Adresse ".$postdata['email']." erhalten.</div>";
} else {
		echo "<h1>Ups</h1>";
	echo "<div>Bei der Anmeldung ist etwas schief gelaufen, bitte versuchen Sie es erneut </div>";
	
	echo "<hr><small>".$resp['beschreibung']."</small>";

}
	return $resp;
}

function fetchTreffpunkt($id, $sessionInfo) {
	$params=array("oid" => $id);
    $treffpunkt=post($sessionInfo, opcFetchTreffpunkt, $params, "{}", $debug) ;

	return $treffpunkt;
}

function renderTerminDetail($resp, $sessionInfo, $showmap, $cssid) {
	$ep = $resp;
	
	
	date_default_timezone_set('Europe/Berlin');
	$von = new DateTime($ep["von"]);
	$bis = new DateTime($ep["bis"]);
	
	echo "<div id='".$cssid."'  class='clearfix eb-category-2 eb-event'>";


	echo "<div class='eb-box-heading clearfix'>";
		echo "<h1 class='eb-page-heading'>".$ep["produkt_titel"]."</h1>";
	echo "</div>";
	echo "<div id='eb-event-details' class='eb-description'>";

	echo "<div class='eb-description-details clearfix' itemprop='description'>".$ep["produkt_beschreibung"]."</div>";

	echo "<table class='table table-bordered table-striped'><tbody>";
		
		echo "<tr><td>Beginn</td><td>".$von->format('j.m.Y - H:i')."</td></tr>";
		echo "<tr><td>Ende</td><td>".$bis->format('j.m.Y - H:i')."</td></tr>";
		echo "<tr><td>max. Teilnehmer</td><td>".$ep["maxtn"]."</td></tr>";
		echo "<tr><td>aktuelle Teilnehmer</td><td>".$ep["tn"]."</td></tr>";
		echo "<tr><td>verfügbare Plätze</td><td>".($ep["maxtn"]-$ep["tn"])."</td></tr>";
		if ($ep["preis"] >0 )echo "<tr><td>Preis</td><td>".$ep["preis"]."</td></tr>";

		echo "<tr><td>Ort</td><td>".$ep["treffpunkt_name"]."</td></tr>";

	echo "</tbody></table>";
	
	renderAnmeldeButton($ep["maxtn"], $ep["tn"], $ep["oid"]);

	echo "</div>";
	echo "</div>";
	
	if($showmap) echo "<iframe src='".$ep["treffpunkt_link"]."' width = '100%' height = '400px' ></iframe>";
}

function renderTerminDetailListenansicht($resp, $sessioninfo) {
	echo "<div id='eb-events'>";

	foreach ($resp[items][0][items] as $termin) {
		renderTerminDetail($termin, $sessionInfo, false, 'bidat_list');
	}
	echo "</div>";

	
}

function renderProduktDetail($resp, $sessionInfo) {
	$pc = $resp[items][0];
	echo "<div class='container'>";
	
	echo "<div class='produkt'>";
	echo "<h2>".$pc["name"]."</h2>";
	echo "<h3>".$pc["untertitel"]."</h3>";
	$beschreibung = trim($pc["beschreibung"]);
	if(strlen($beschreibung)<3) $beschreibung = lorem;
	
	echo "<div class='beschreibung'>".$beschreibung."</div>";
	
	echo "<div class='row'>";

	echo "<div class='col-md-4 sprachen'><h3>Verfügbare Sprachen</h3><ul>";
	
	foreach($pc["_sprachen_"]["items"] as $sprache) {
		echo "<li>".$sprache["label"]."</li>";
	}
	
	echo "</ul></div>";
	
	echo "<div class='col-md-4 treffpunkt'><h3>Treffpunkt</h3>";
		$treffpunkt = fetchTreffpunkt($pc["treffpunkt"]["oid"], $sessionInfo);
		echo "<div class='treffpunktname'>".$treffpunkt["name"]."</div>";
			echo "<div class='oepnv'><em>Hinweis zur Erreichbarkeit</em></div>";
		echo "<div class='oepnv'>".$treffpunkt["oepnv"]."</div>";
	echo "</div>";
	
	echo "<div class='col-md-4 treffpunkt'><h3>Weitere Infos</h3>";
		echo "<div class='row'>";
			echo "<div class='col-md-6'>Dauer</div>";
			echo "<div class='col-md-6'>".$pc["dauer"]." h</div>";
		echo "</div>";

		echo "<div class='row'>";
			echo "<div class='col-md-6'>min TN</div>";
			echo "<div class='col-md-6'>".$pc["minTN"]."</div>";
		echo "</div>";
	
		echo "<div class='row'>";
			echo "<div class='col-md-6'>max TN</div>";
			echo "<div class='col-md-6'>".$pc["maxTN"]."</div>";
		echo "</div>";

		
	echo "</div>";
	echo "</div>";
	echo "</div>";
	echo "</div>";
}
 
/**
 *  Main.
 *
 */
 
try {
    $sessionInfo=login($ini['host'], 'nfbg', 'bobby', $debug);
     
   
    //$resp=get($sessionInfo, opcObjectlistProdukt, $params, $debug) ;
    
    $produktid = $_GET['produkt'];
    $treffpunktid = $_GET['treffpunkt'];
    $registerid = $_GET['register'];
    $modulid = $_GET['modul'];
    $formid = $_GET['form'];
    $stichwortkey = $_GET['stichwort'];

    if($produktid >100) {
    	
    	$params=array(
    		"systems_sdw_org_Organisation"=>$ini["oid_org"], 
    		"systems_sdw_hr_Angestellter"=>$ini['oid_ang'],
    		"de_stattbuchung_Produkt"=>$produktid,
    		"de_stattbuchung_Kanal"=>$ini["apikey"]
    		);
    	$resp=post($sessionInfo, opcLoadProduktContainer, $params, "{}", $debug) ;
	
		renderProduktDetail($resp, $sessionInfo);
    	
    } else if($treffpunktid > 100) {
    	
    	fetchTreffpunkt($treffpunktid, $sessionInfo);
    	
    } else if($registerid == 872) {
    	
    	sendAnmeldung($registerid, $sessionInfo, $ini['apikey'], $ini['oid_ang'], $_POST);
    	
    } else if ($modulid > 100) {
	    
		renderTerminDetail(fetchTermindetail($modulid, $sessionInfo, $ini['apikey'], 'eb-event-page'), $sessionInfo);
	    
    } else if ($formid > 100) {
	    
		renderAnmeldeformular(fetchTermindetail($formid, $sessionInfo, $ini['apikey']), $sessionInfo);
	    
    } else if($treffpunktid > 100) {
    	
    	renderAnmeldeformular($registerid, $sessionInfo);
    	
    } else {
        $query =$_GET['query'];
		$query=htmlspecialchars($query);
	
		$params=array("oid" => "0",
			"de_stattbuchung_Kanal"=>$ini["apikey"],
			"maxResultLength"=>100 );
		if($query !== '') {$params['muster']=$query;}	
		
		if($stichwortkey != 'NULL') {
			$params['de_stattbuchung_Stichwort_key'] = $stichwortkey;
		}	
			
	
		$jsonString ="{oid:0}";
	    $resp=post($sessionInfo, opcCalendarByChannel, $params, $jsonString, $debug) ;
	    
	    if(is_null($stichwortkey)) renderTerminliste($resp, $sessionInfo, $query);
	    else renderTerminDetailListenansicht($resp, $sessioninfo);
	    
    }
 
    //  nicht vergessen!
    logoff($sessionInfo, $debug);
 
} catch (Exception $e) {
    echo 'Exception: '.$e->getMessage()." code: ".$e->getCode()."<br/>";
}
 
?></p>
</div>
</div>

 
</body>
</html>