<?php


/**
 *  
 * Ein Client für die Darstellung von Kalenderterminen und die Online-Buchung dieser Termine
 * im Kontext von community.stattbuchung.de
 * 
 * Jede Darstellung liest dabei die Daten vom community.stattbuchung.de Server ein und gibt diese Entsprechend aus
 * Zur Authentifizierung wird Benutzername, Kennwort und der API-Key benötigt.
 * Sollte im produktiven Einsatz immer SSL-gesichert verwendet werden.
 *
 *  Autor: Thomas Mack
 */


include('client.php');
include('template.php');
$ini = parse_ini_file('config.ini');

$debug=false;
 
/**
 * Für jede Aktion wird ein Opcode an den Server geschickt.
 * Dieser wird mit weiteren Daten im JSON-Format parametrisiert.
 * Die jeweils notwendigen Paramater variieren.
 * In jedem Fall sollte der API-Key unter dem Attribut 'de_stattbuchung_Kanal'
 * enthalten sein
 */
define("opcObjectlistProdukt", 256160);
define("opcObjectlistEventNachZeitraum", 255100);
define("opcQueryProdukt",256167);
define("opcLoadProduktContainer",256168);
define("opcFetchTreffpunkt",256141);
define("opcCalendarByChannel",257000);
define("opcFetchTermindetail",257001);
define("opcAddAnmeldung",257002);
define("opcStichwortlistByKanal",257003);

/**
 * Ende OPCODE Definition
 */

define("templatePath",$ini['templatePath'].'/');

function renderProduktliste($resp, $sessionInfo, $query) {
	echo "<div class='container'>";
	echo "<div class='result'><h3><span class='fa fa-search'></span>Die Suche nach <em>".$query."</em> ergab ".$resp["items"][0]["resultSetCount"]." Teffer</h3>";
	$queryresult = $resp["items"];

	foreach ($resp[items][0][items] as $produkt) {
		echo "<div class='produktlistitem'><span class='fa  fa-external-link'></span>";
		echo "<a href='index.php?produkt=".$produkt["oid"]."'>";
		echo $produkt["label"];
		echo "</a>";
		echo "</div>";
	}
	echo "</div>";
	echo "</div>";

}

/**
 * Beispiel für eine Navigation, die Termine jeweils eines Monats anbietet.
 * StattBuchung benötigt immer einen Zeitraum von, bis im ISO-FORMAT
 * Mit dieser Methode wird eine Abstraktion auf Ebenen von Monaten erreicht.
 * 
 * Die Methode nutzt das HTML-Template 'nav_liste.inc'
 * Für die Darstellung des Dezember 2018 werden folgende Parameter übergeben:
 *	- "monat_name" => 'Dezember' (Abhähngig von der Server-Locale),
 *	- "monat_down" => 11,
 *	- "jahr_down" => 2018,
 *	- "monat_up" => 1,
 *	- "jahr_up" => 2019
*/
function renderMonatNavigation($start) {
	date_default_timezone_set('Europe/Berlin');
	$akt = $start->getTimestamp();
	$start->sub(new DateInterval('P1M'));
	$ts =$start->getTimestamp();
	$start->add(new DateInterval('P2M'));
	$tsUp =$start->getTimestamp();
	$params=array(
	    	"monat_name" => strftime('%B',$akt),
	    	"monat_down" => strftime('%m',$ts),
	    	"jahr_down" => strftime('%G',$ts),
	    	"monat_up" => strftime('%m',$tsUp),
	    	"jahr_up" => strftime('%G',$tsUp)
			);
	$viewRow = new Template($params, templatePath);
	echo $viewRow->render('nav_liste.inc');

}


/**
 * Darstellung einer einfach Suchbox im oberen Seitenbereich.
 * Die Darstellung wird im Template searchbox.inc erzeugt.
 * Die Parametrisierung erfolgt in der HTML-Datei.
 * Im einfachsten Fall wird nur ein Query-String übergeben.
 * Es können zudem die Optionen von, bis, schlagwort, eventtyp gesetzt werden.
 * 
 */

function renderSearchBox() {
	$params=array();
	date_default_timezone_set('Europe/Berlin');
	$viewRow = new Template($params, templatePath);
	echo $viewRow->render('searchbox.inc');

}

/**
 * Darstellung des Anmeldeformulars für eine Veranstaltung.
 * Die Validierung der Felder ist in der Template-Datei zu realisieren.
 * Falls eine online-Zahlung angeboten werden soll muss diese selbst implementiert werden.
 * Erst nach erfolgter Zahlung dürfen die Daten an StattBuchung übermittelt werden.
 * 
 */

function renderAnmeldeformular($resp, $sessionInfo) {
	$ep = $resp;
	
	date_default_timezone_set('Europe/Berlin');

	$viewRow = new Template($ep, templatePath);
	$viewRow->properties['freitn'] =$ep["maxtn"]-$ep["tn"];
	$viewRow->properties['von'] = new DateTime($ep["von"]);
	$viewRow->properties['bis'] = new DateTime($ep["bis"]);

	echo $viewRow->render('anmeldeformular.inc');

}


function renderTerminliste($resp, $sessionInfo, $query, $templatePrefix, $swlist) {
	
	date_default_timezone_set('Europe/Berlin');
	$view = new Template($swlist, templatePath);
	
	echo $view->render($templatePrefix.'_head.inc');

	foreach ($resp[items][0][items] as $ep) {
		
		if($odd == true) {
			$ep['odd_even'] = 'odd';
			$odd = false;
		} else {
			$ep['odd_even'] = 'even';
			$odd = true;
		}

		$viewRow = new Template($ep, templatePath);
		if(is_int($ep["maxtn"])) {
			$viewRow->properties["freitn"]=$ep["maxtn"]-$ep["tn"];
		} else {
			$viewRow->properties["freitn"]=99-$ep["tn"];
			$viewRow->properties["maxtn"]=99;
		}

		$viewRow->properties['von'] = new DateTime($ep["von"]);
		$viewRow->properties['bis'] = new DateTime($ep["bis"]);

		echo $viewRow->render($templatePrefix.'_row.inc');

	}
	echo $view->render($templatePrefix.'_foot.inc');

}



function sendAnmeldung($id, $sessionInfo, $apikey, $oidang, $postdata) {
	date_default_timezone_set('Europe/Berlin');

	$gebdate = new DateTime( $postdata['geburtsdatum']);
	$params=array(
	    	"oid" => $postdata['de_stattbuchung_event_Modul'],
	    	"anrede"=>$postdata['anrede'],
	    	"vorname"=>$postdata['vorname'],
	    	"nachname"=>$postdata['nachname'],
	    	"strasse"=>$postdata['strasse'],
	    	"plz"=>$postdata['plz'],
	    	"ort"=>$postdata['ort'],
	    	"email"=>$postdata['email'],
	    	"telefon"=>$postdata['telefon'],
	    	"institution"=>$postdata['institution'],
	    	"geburtsdatum"=>$gebdate->format(DateTime::ATOM),
	    	"de_bidat_av_Profiltyp_geburtsort"=>$postdata['geburtsort'],
	    	"kommentar"=>$postdata['kommentar'],
    		"de_stattbuchung_event_Modul"=>$postdata['de_stattbuchung_event_Modul'],
    		"de_stattbuchung_Kanal"=>$apikey,
    		"de_stattbuchung_Teilnehmerart_00"=>$postdata['tnvoll'],
    		"de_stattbuchung_Teilnehmerart_01"=>$postdata['tnerm'],
    		"de_stattbuchung_Verkaufsstelle"=>'BZA',
    		"systems_sdw_hr_Angestellter"=>$oidang
    	);
   	$resp=post($sessionInfo, opcAddAnmeldung, $params, "{}", $debug) ;

	if($resp['beschreibung'] == 'OK') {
		echo "<h1>Herzlichen Dank für Ihre Anmeldung</h1>";
		echo "<div>Sie sollten in Kürze eine Nachricht über die Adresse ".$postdata['email']." erhalten.</div>";
	} else {
			echo "<h1>Ups</h1>";
		echo "<div>Bei der Anmeldung ist etwas schief gelaufen, bitte versuchen Sie es erneut </div>";
		
		echo "<hr><small>".$resp['beschreibung']."</small>";
	
	}
	return $resp;
}

function renderTerminDetail($resp, $sessionInfo, $showmap, $cssid) {
	$ep = $resp;
	//var_dump($resp);
	date_default_timezone_set('Europe/Berlin');
	
	$view = new Template($ep, templatePath);

	$view->properties['cssid'] = $cssid;
	if(is_int($ep["maxtn"])) {
		$view->properties['freitn'] =$ep["maxtn"]-$ep["tn"];
	} else {
		$view->properties['freitn'] =99-$ep["tn"];
		$view->properties['maxtn'] =99;
		
	}
	$view->properties['von'] = new DateTime($ep["von"]);
	$view->properties['bis'] = new DateTime($ep["bis"]);
	$view->properties['validFrom'] = new DateTime($ep["validFrom"]);

	$view->properties['showmap'] = $showmap;

	echo $view->render('termindetail.inc');

}

function renderTerminDetailListenansicht($resp, $sessioninfo) {
	echo "<div id='bidat-events'>";

	if($resp[items][0][itemCount]==0) {
		echo "<div class='error-message'>Ihre Anfrage hat keine Termine ergeben.</div>";
	} else {
		$odd = true;
		foreach ($resp[items][0][items] as $termin) {
			if($odd == true) {
				$termin['odd_even'] = 'odd';
				$odd = false;
			} else {
				$termin['odd_even'] = 'even';
				$odd = true;
			}
			renderTerminDetail($termin, $sessionInfo, false, 'bidat_list');
		}
	}
	echo "</div>";
	
}



function fetchTreffpunkt($id, $sessionInfo) {
	$params=array("oid" => $id);
    $treffpunkt=post($sessionInfo, opcFetchTreffpunkt, $params, "{}", $debug) ;

	return $treffpunkt;
}

/**
 * Lädt die Informationen zu einem Termin von StattBuchung
 * 
 */

function fetchTermindetail($id, $sessionInfo, $apikey, $verkaufstelle) {
    $params=array(
	    	"oid" => $id,
    		"de_stattbuchung_event_Modul"=>$id,
    		"de_stattbuchung_Verkaufsstelle"=>$verkaufstelle,
    		"de_stattbuchung_Kanal"=>$apikey
    	);
   	$resp=post($sessionInfo, opcFetchTermindetail, $params, "{}", $debug) ;

	return $resp;
}


 
/**
 *  Main.
 *
 */
 
try {
    $sessionInfo=login($ini['host'], $ini['user'], $ini['psw'], $debug);
     
   	date_default_timezone_set('Europe/Berlin');

    //$resp=get($sessionInfo, opcObjectlistProdukt, $params, $debug) ;
    
    $treffpunktid = $_GET['treffpunkt'];
    $registerid = $_GET['register'];
    $modulid = $_GET['modul'];
    $formid = $_GET['form'];
    $stichwortkey = $_GET['stichwort'];

	$monat = $_GET['monat'];
	$jahr = $_GET['jahr'];
	$maxResult = $_GET['maxResultLength'];
	$teaser = $_GET['teaser'];
	$viewStyle = $_GET['style'];

	$verkaufstelle = $ini['de_stattbuchung_Verkaufsstelle'];

	$view = new Template(array(), templatePath);
	if($teaser > 0) {
		$view->properties['bodyid']="_teaser";
	}

	
	$view->title=$ini["seitentitel"];
	echo $view->render('header.inc');

	if ($ini['show_searchbox']==true) {
		renderSearchBox(); 
	} 
	
	
	if ($ini['show_stichwort_selector'] == true) {
		$params=array("oid" => "0",
			"de_stattbuchung_Kanal"=>$ini["apikey"],
			"de_stattbuchung_event_Typ"=>$ini["de_stattbuchung_event_Typ"]);
		$swlist=post($sessionInfo, opcStichwortlistByKanal, $params, $jsonString, $debug) ;
	} else {
		$swlist = NULL;
	}
	

    if($treffpunktid > 100) {
    	
    	fetchTreffpunkt($treffpunktid, $sessionInfo);
    	
    } else if($registerid == 872) {
    	
    	sendAnmeldung($registerid, $sessionInfo, $ini['apikey'], $ini['oid_ang'], $_POST);
    	
    } else if ($modulid > 100) {
	    
		renderTerminDetail(fetchTermindetail($modulid, $sessionInfo, $ini['apikey'], $verkaufstelle), $sessionInfo, TRUE, 'eb-event-page');
	    
    } else if ($formid > 100) {
	    
		renderAnmeldeformular(fetchTermindetail($formid, $sessionInfo, $ini['apikey'], $verkaufstelle), $sessionInfo);
	    
    } else if($treffpunktid > 100) {
    	
    	renderAnmeldeformular($registerid, $sessionInfo);
    	
    } else if($teaser > 0) {
    	$params=array("oid" => "0",
			"de_stattbuchung_Kanal"=>$ini["apikey"],
			"de_stattbuchung_event_Typ"=>$ini["de_stattbuchung_event_Typ"],
			"maxResultLength"=>$teaser);
		$resp=post($sessionInfo, opcCalendarByChannel, $params, $jsonString, $debug) ;
		renderTerminliste($resp, $sessionInfo, '','teaser', NULL);
	
    	
    } else {
        $query =$_GET['query'];
		$query=htmlspecialchars($query);
	
		$params=array("oid" => "0",
			"de_stattbuchung_Kanal"=>$ini["apikey"],
			"de_stattbuchung_event_Typ"=>$ini["de_stattbuchung_event_Typ"]);
		if($query !== '') {$params['muster']=$query;}	
		if($maxResult > 0) {
			$params['maxResultLength'] = $maxResult;
		} else {
			$params['maxResultLength'] = 100;
		}
		
		if($stichwortkey != 'NULL') {
			$params['de_stattbuchung_Stichwort_key'] = $stichwortkey;
		}	
		
		
		if(!is_null($monat)) {
			if(is_null($jahr)) {
				$jahr = date ('Y', time());
			}
			if ($monat >12) {
				$jahr++;
				$monat = $monat-12;
			} else if ($monat ==0) {
				$jahr--;
				$monat = 12;
			}
			
			$start = new DateTime( '1.'.$monat.'.'.$jahr);
			$ende = new DateTime( '1.'.$monat.'.'.$jahr);
			$ende->add(new DateInterval('P1M'));
			$ende->sub(new DateInterval('P1D'));

			$params['von'] = $start->format(DateTime::ATOM);
			$params['bis'] = $ende->format(DateTime::ATOM);
			
			
		}
		$jsonString ="{oid:0}";
	    $resp=post($sessionInfo, opcCalendarByChannel, $params, $jsonString, $debug) ;
	    if($monat > 0) renderMonatNavigation($start);
	    if(is_null($stichwortkey) || $viewStyle == 'table') renderTerminliste($resp, $sessionInfo, $query, 'table', $swlist);
	    else renderTerminDetailListenansicht($resp, $sessioninfo);

    }
 
    // Ausloggen nicht vergessen!
    logoff($sessionInfo, $debug);
 
} catch (Exception $e) {
    echo 'Exception: '.$e->getMessage()." code: ".$e->getCode()."<br/>";
}

echo $view->render('footer.inc');
 
?>
